#!/bin/bash

DEBUG="true"

edebug()
{
    if [ "$DEBUG"="true" ]
    then
        echo -e "DEBUG: $@"
    fi
}

prepareSavesDir()
{
    #check if saves dir exists in wine prefix and move it - ensure compatibility with previous versions
    edebug "Checking if legacy saves directory exists"
    if [ -d "$wineConfig/drive_c/users/$USER/Saved Games/Two Worlds Saves" ]
    then
        if [ ! -L "$wineConfig/drive_c/users/$USER/Saved Games/Two Worlds Saves" ]
        then
            edebug "Legacy saves directory exists, moving it to new location"
            mv "$wineConfig/drive_c/users/$USER/Saved Games/Two Worlds Saves" "$startDir/Game/"
        else
            edebug "Legacy saves directory not detected"
        fi
    fi

    edebug "Updating saves directory structure:"
    edebug "Preparing save games placeholder"
    mkdir -p "$wineConfig/drive_c/users/$USER/Saved Games"

    edebug "Preparing save games directory"
    mkdir -p "$startDir/Game/Two Worlds Saves"

    edebug "Symlinking placeholder with actual directory"
    ln -sf "$startDir/Game/Two Worlds Saves" "$wineConfig/drive_c/users/$USER/Saved Games/"
}

logfile=TW1.log.txt
exec > $logfile 2>&1

startDir="$( cd "$(dirname "$0")" ; pwd -P )"
gameDir="$startDir/Game/TwoWorlds"
wineConfig="$WINEPREFIX"

edebug "********************STARTING Two Worlds*******************"
edebug "curernt variables are:"
edebug "PATH: $PATH"
edebug "pwd: `pwd`"
edebug "startDir: $startDir"
edebug "gameDir: $gameDir"
edebug "wineConfig: $wineConfig"
edebug "done!"
edebug "*********************************************************"

echo "Starting the game now..."
rm -rf "$wineConfig/dosdevices"
mkdir "$wineConfig/dosdevices"
ln -s "$wineConfig/drive_c/" "$wineConfig/dosdevices/c:"
ln -s "$startDir/Game/" "$wineConfig/dosdevices/d:"

prepareSavesDir
