#!/usr/bin/env bash

set -e

SCRIPT_BASE_PATH=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )
cd "$SCRIPT_BASE_PATH"

folder="$1"

if [ -z "$folder" ]; then
  #echo "Usage: $0 /path/to/folder"
  #exit 1
  cd "$SCRIPT_BASE_PATH"
fi

cd "$folder" || { echo "Failed to access folder: $folder"; exit 1; }

for f in *.wmv; do 

  # Skip files already backed up or processed
  [[ "$f" == ori_* ]] && continue

  # If output already exists, skip
  if [[ -f "ori_$f" ]]; then
    echo "Skipping '$f' – already processed."
    continue
  fi

  echo "Processing '$f'..."
  ffmpeg -i "$f" -c:v copy -b:a 192k -ar 44100 -ac 2 "tmp_$f"
  mv "$f" "ori_$f"
  mv "tmp_$f" "$f"
done
